/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;

public class CornerPillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return switch (type) {
                case BlockType.FRAMED_PANEL -> CornerPillarSkipPredicate.testAgainstPanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> CornerPillarSkipPredicate.testAgainstPillar(level, pos, dir, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> CornerPillarSkipPredicate.testAgainstCorner(level, pos, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> CornerPillarSkipPredicate.testAgainstDoublePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_STAIRS -> CornerPillarSkipPredicate.testAgainstStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> CornerPillarSkipPredicate.testAgainstHalfStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> CornerPillarSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, dir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstSlopePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstExtendedSlopePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstDoubleSlopePanel(level, pos, dir, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> CornerPillarSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, dir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side != dir && side != dir.m_122428_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && dir == adjDir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir && adjDir == dir.m_122428_() || side == dir.m_122428_() && adjDir == dir.m_122427_()) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (Utils.isY(side) && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (adjTop && side == Direction.DOWN || !adjTop && side == Direction.UP) {
            return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_NE);
        if (side == dir && (adjDir == dir.m_122427_() || adjDir == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir.m_122428_(), dir.m_122428_());
        }
        if (side == dir.m_122428_() && (adjDir == dir || adjDir == dir.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        boolean bl = adjTop = adjState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.TOP;
        if (adjTop && side == Direction.UP || !adjTop && side == Direction.DOWN) {
            if (adjShape == StairsShape.OUTER_LEFT) {
                return dir == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
            if (adjShape == StairsShape.OUTER_RIGHT) {
                return dir.m_122428_() == adjDir && SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
        }
        return false;
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (adjType == StairsType.VERTICAL ? (side == dir.m_122428_() || side == dir) && adjDir == dir : Utils.isY(side) && side == Direction.DOWN == adjType.isTop() && adjDir == dir) {
            return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(side) && adjDir == dir.m_122424_()) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (adjDir == dir && (side == dir || side == dir.m_122428_())) {
            return SideSkipPredicate.compareState(level, pos, side, dir, dir);
        }
        if (adjDir == dir.m_122428_() && side == dir.m_122428_() || adjDir == dir.m_122427_() && side == dir) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (Utils.isY(side) && side == Direction.UP == adjTop) {
            if (adjRight && adjDir == dir.m_122428_() || !adjRight && adjDir == dir) {
                return SideSkipPredicate.compareState(level, pos, side, dir, side.m_122424_());
            }
        } else if ((adjRight && side == dir || !adjRight && side == dir.m_122428_()) && (adjRight && adjDir == dir.m_122424_() || !adjRight && adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side != dir && side != dir.m_122428_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (adjRot.isVertical() || side != adjRot.withFacing(adjDir)) {
            return false;
        }
        if (!adjFront && (adjDir == dir || adjDir == dir.m_122428_()) || adjFront && (adjDir == dir.m_122424_() || adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side != dir && side != dir.m_122428_()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjRot.isVertical()) {
            return false;
        }
        if (side == dir && adjDir == dir.m_122428_() && adjRot == HorizontalRotation.LEFT) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        if (side == dir.m_122428_() && adjDir == dir && adjRot == HorizontalRotation.RIGHT) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (adjRot.isVertical() || side.m_122434_() != adjRot.withFacing(adjDir).m_122434_()) {
            return false;
        }
        if (!adjFront && (adjDir == dir || adjDir == dir.m_122428_()) || adjFront && (adjDir == dir.m_122424_() || adjDir == dir.m_122427_())) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (adjRot.isVertical() || side.m_122434_() != adjRot.withFacing(adjDir).m_122434_()) {
            return false;
        }
        if (side == dir && adjRot == HorizontalRotation.LEFT || side == dir.m_122428_() && adjRot == HorizontalRotation.RIGHT) {
            return SideSkipPredicate.compareState(level, pos, side);
        }
        return false;
    }
}

